// Define API base URL (for TrueHost hosting)
const API_BASE_URL = 'https://yourdomain.com/api/';

// Login form submission
document.getElementById('loginForm')?.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const email = document.getElementById('loginEmail').value;
    const password = document.getElementById('loginPassword').value;
    const submitBtn = this.querySelector('button[type="submit"]');
    const messageDiv = document.getElementById('loginMessage');
    
    // Show loading spinner
    submitBtn.disabled = true;
    submitBtn.querySelector('.spinner-border').classList.remove('d-none');
    
    fetch(API_BASE_URL + 'login.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ email, password }),
        credentials: 'include'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Store user info in session storage
            sessionStorage.setItem('userName', data.user.name);
            
            // Redirect to dashboard
            window.location.href = 'dashboard.html';
        } else {
            // Show error message
            messageDiv.className = 'error';
            messageDiv.textContent = data.error || 'Login failed. Please try again.';
            messageDiv.style.display = 'block';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        messageDiv.className = 'error';
        messageDiv.textContent = 'An error occurred. Please try again later.';
        messageDiv.style.display = 'block';
    })
    .finally(() => {
        // Hide loading spinner
        submitBtn.disabled = false;
        submitBtn.querySelector('.spinner-border').classList.add('d-none');
    });
});

// Registration form submission
document.getElementById('registerForm')?.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const fullName = document.getElementById('fullName').value;
    const email = document.getElementById('registerEmail').value;
    const company = document.getElementById('company').value;
    const password = document.getElementById('registerPassword').value;
    const confirmPassword = document.getElementById('confirmPassword').value;
    const submitBtn = this.querySelector('button[type="submit"]');
    const messageDiv = document.getElementById('registerMessage');
    
    // Validate passwords match
    if (password !== confirmPassword) {
        messageDiv.className = 'error';
        messageDiv.textContent = 'Passwords do not match';
        messageDiv.style.display = 'block';
        return;
    }
    
    // Show loading spinner
    submitBtn.disabled = true;
    submitBtn.querySelector('.spinner-border').classList.remove('d-none');
    
    fetch(API_BASE_URL + 'register.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ full_name: fullName, email, company, password }),
        credentials: 'include'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            messageDiv.className = 'success';
            messageDiv.textContent = data.message;
            messageDiv.style.display = 'block';
            
            // Reset form after 2 seconds and redirect to login
            setTimeout(() => {
                document.getElementById('registerForm').reset();
                window.location.href = 'index.html';
            }, 2000);
        } else {
            messageDiv.className = 'error';
            messageDiv.textContent = data.error || 'Registration failed. Please try again.';
            messageDiv.style.display = 'block';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        messageDiv.className = 'error';
        messageDiv.textContent = 'An error occurred. Please try again later.';
        messageDiv.style.display = 'block';
    })
    .finally(() => {
        // Hide loading spinner
        submitBtn.disabled = false;
        submitBtn.querySelector('.spinner-border').classList.add('d-none');
    });
});